<?php

require __DIR__ . '/woocommerce/template-tags.php';
require __DIR__ . '/structure/header.php';


add_action( 'init', 'custom_remove_footer_credit', 10 );


function custom_remove_footer_credit () {
    remove_action( 'storefront_footer', 'storefront_credit', 20 );
    add_action( 'storefront_footer', 'custom_storefront_credit', 20 );
}

function custom_storefront_credit() {
    ?>
    <div class="site-info">
        &copy; <?php echo get_bloginfo( 'name' ) . ' ' . date( 'Y' ); ?>
    </div><!-- .site-info -->

    <?php


}

add_filter( 'storefront_handheld_footer_bar_links', 'remove_handheld_footer_links' );
function remove_handheld_footer_links( $links ) {
    unset( $links['my-account'] );
    unset( $links['cart'] );

    return $links;
}



/**
 * Disable default widget location
 */
function storefront_footer_widgets() {}


