<?php
// First Register the Tab by hooking into the 'woocommerce_product_data_tabs' filter
add_filter( 'woocommerce_product_data_tabs', 'add_warranty_data_tab' );
function add_warranty_data_tab( $product_data_tabs ) {
    $product_data_tabs['warranty-tab'] = array(
        'label' => __( 'Warranty', 'woocommerce' ),
        'target' => 'warranty_data',
        'class'     => array( 'show_if_simple' ),
    );
    return $product_data_tabs;
}
/** CSS To Add Custom tab Icon */
function wcpp_custom_style() { ?>
    <style>
        #woocommerce-product-data ul.wc-tabs li.warranty-tab_options a:before { font-family: WooCommerce; content: '\e01c'; }
    </style>
    <?php
}
add_action( 'admin_head', 'wcpp_custom_style' );



// functions you can call to output text boxes, select boxes, etc.
add_action('woocommerce_product_data_panels', 'woocom_warranty_data_fields');

function woocom_warranty_data_fields() {
    global $post;

    // Note the 'id' attribute needs to match the 'target' parameter set above
    ?> <div id = 'warranty_data'
            class = 'panel woocommerce_options_panel' > <?php
    ?> <div class = 'options_group' > <?php

        // Number Field
        woocommerce_wp_text_input(
            array(
                'id' => '_warranty_field',
                'label' => __( 'Warranty in Months', 'woocommerce' ),
                'placeholder' => '',
                'description' => __( 'Give warranty period in months here.', 'woocommerce' ),
                'type' => 'number',
                'custom_attributes' => array(
                    'step' => '1',
                    'min' => '0'
                )
            )
        );

        ?> </div>

    </div><?php
}

/** Hook callback function to save custom fields information */
function woocom_save_warranty_field($post_id) {
    $warranty_field = $_POST['_warranty_field'];
    if (!empty($warranty_field)) {
        update_post_meta($post_id, '_warranty_field', esc_attr($warranty_field));
    }
}

add_action( 'woocommerce_process_product_meta_simple', 'woocom_save_warranty_field'  );

// You can uncomment the following line if you wish to use those fields for "Variable Product Type"
//add_action( 'woocommerce_process_product_meta_variable', 'woocom_save_proddata_custom_fields'  );